/* $Id: parms.c,v 1.123 1999/02/10 17:31:55 dhiller Exp $ */
/* Copyright (C) 1994 - 1998, Hewlett-Packard Company, all rights reserved. */
/* Written by Eric Backus */

/* Okay, this file is somewhat cryptic.  I feel bad for that, and in
   an attempt to make amends, I'm putting lots of comments in this
   file.

   This file defines the code for the more than 100 functions used to
   set parameters, get parameters, and get parameter limits on a
   Semaphore.  Most of these functions are very similar, and typing
   all that out would be error prone.  It would be a pain to redefine
   these functions later if you had to manually change over 100
   functions.  It would also obscure the differences that actually do
   exist between them.  To avoid all that typing and to make it easier
   to modify them later, I use some complicated #defines.

   For any given parameter, we must have a function to set that
   parameter, and a function to get the current value.  For numerical
   parameters, we must also have a function which gives the minimum
   and maximum limits for that parameter.

   To set a parameter, we use the low-level function i1432_set_mod or
   i1432_set_chan.  These functions take an ID, a command, and a
   value, and send the command and value to all channels associated
   with the ID.

   To get the current value of a parameter, we use the low-level
   function i1432_get_mod_xxx or i1432_get_chan_xxx.  The xxx is
   replaced with "short", "float", or "long", depending on the type of
   parameter.  These functions take an ID and a Semaphore register
   address.  These functions directly read the current value in the
   Semaphore register.

   The get the minimum and maximum values of a numerical parameter, we
   use the low-level function i1432_get_mod_limits or
   i1432_get_chan_limits.  These functions take an ID and command, and
   return the minimum value, maximum value, default value, and step
   size for that command.

   There are two classes of parameters: those that apply to an
   individual channel, and those that apply to a module as a whole.
   Corresponding to those two classes, we have two classes of all the
   low-level set- and get- functions.  When setting an individual
   channel's parameter, we must send a command for each channel
   associated with the ID.  When setting a module-wide parameter, we
   need only send the command once for each module that has channels
   associated with the ID.

   All of the low-level i1432 functions used here are defined in
   set.c.

   To make the complicated #defines work better, I had to use the
   ANSI-C "##" and "#" operators.  The "##" operator means "combine
   the things before and after the ## into one token".  If this
   weren't used, it would not be possible to combine "e1432_get_" and
   a parameter name into a single function name for the C compiler.
   The "#" operator means "turn the parameter following into a valid C
   string".  If this weren't used, it would not be possible to put the
   parameter name (which was already used to create the function name)
   in a printf string.  It's not pretty, but it works. */

#include "sema.h"

#define GET(str, reg, typein, typeout, class)	\
SHORTSIZ16 EXPORT \
e1432_get_##str(E1432ID hw, SHORTSIZ16 ID, typein * value)\
{\
    TRACE_PRINTF(0, ("e1432_get_" #str "(0x%p, %d, 0x%p)\n",\
		     hw, ID, value));\
    return i1432_get_##class##_##typeout(hw, ID, reg, value);\
}

#define GET_LIMITS(str, cmd, class)	\
SHORTSIZ16 EXPORT \
e1432_get_##str##_limits(E1432ID hw, SHORTSIZ16 ID,\
			 FLOATSIZ32 *min, FLOATSIZ32 *max,\
			 FLOATSIZ32 *def, FLOATSIZ32 *step)\
{\
    TRACE_PRINTF(0, ("e1432_get_" #str "_limits(0x%p, %d, "\
		     "0x%p, 0x%p, 0x%p, 0x%p)\n",\
		     hw, ID, min, max, def, step));\
    return i1432_get_##class##_limits(hw, ID, cmd, min, max, def, step);\
}

#define GET_FIXED_LIMITS(str, lmin, lmax, ldef, lstep)		\
SHORTSIZ16 EXPORT						\
e1432_get_##str##_limits(E1432ID hw, SHORTSIZ16 ID,		\
			 FLOATSIZ32 *min, FLOATSIZ32 *max,	\
			 FLOATSIZ32 *def, FLOATSIZ32 *step)	\
{								\
    *min = (FLOATSIZ32) (lmin);					\
    *max = (FLOATSIZ32) (lmax);					\
    *def = (FLOATSIZ32) (ldef);					\
    *step = (FLOATSIZ32) (lstep);				\
    return 0;							\
}

#define GET_CHAN_LIMITS(str, index)	\
SHORTSIZ16 EXPORT \
e1432_get_##str##_limits(E1432ID hw, SHORTSIZ16 ID,\
			 FLOATSIZ32 *min, FLOATSIZ32 *max,\
			 FLOATSIZ32 *def, FLOATSIZ32 *step)\
{\
    TRACE_PRINTF(0, ("e1432_get_" #str "_limits(0x%p, %d, "\
		     "0x%p, 0x%p, 0x%p, 0x%p)\n",\
		     hw, ID, min, max, def, step));\
    return i1432_get_chan_limits(hw, ID, index, min, max, def, step);\
}

#define	SET(str, reg, cmd, typein, prstr, cast, class)	\
SHORTSIZ16 EXPORT \
e1432_set_##str(E1432ID hw, SHORTSIZ16 ID, typein value)\
{\
    TRACE_PRINTF(0, ("e1432_set_" #str "(0x%p, %d, " #prstr ")\n",\
		     hw, ID, value));\
    return i1432_set_##class(hw, ID, reg, cmd, cast value);\
}

#define SET_GEN(str, reg, cmd, typein, prstr, cast, class, lmin, lmax, errn)\
SHORTSIZ16 EXPORT \
e1432_set_##str(E1432ID hw, SHORTSIZ16 ID, typein value)\
{\
    TRACE_PRINTF(0, ("e1432_set_" #str "(0x%p, %d, " #prstr ")\n",\
		     hw, ID, value));\
    if ( value > lmax || value < lmin )\
    {\
	return i1432_print_error(errn);\
    }\
    return i1432_set_##class(hw, ID, reg, cmd, cast value);\
}

#define	GET_CHAN_SHORT(s, r)	GET(s, r, SHORTSIZ16, short, chan)
#define	GET_MOD_SHORT(s, r)	GET(s, r, SHORTSIZ16, short, mod)
#define	GET_CHAN_FLOAT(s, r)	GET(s, r, FLOATSIZ32, float, chan)
#define	GET_MOD_FLOAT(s, r)	GET(s, r, FLOATSIZ32, float, mod)
#define	GET_CHAN_LONG(s, r)	GET(s, r, LONGSIZ32, long, chan)
#define	GET_MOD_LONG(s, r)	GET(s, r, LONGSIZ32, long, mod)

/* #define GET_CHAN_LIMITS(s, c)	GET_LIMITS(s, c, chan) */
#define GET_MOD_LIMITS(s, c)	GET_LIMITS(s, c, mod)

#define	SET_CHAN_SHORT(s, r, c)	SET(s, r, c, SHORTSIZ16, %d, (LONGSIZ32), chan)
#define	SET_MOD_SHORT(s, r, c)	SET(s, r, c, SHORTSIZ16, %d, (LONGSIZ32), mod)
#define	SET_CHAN_FLOAT(s, r, c)	SET(s, r, c, FLOATSIZ32, %g, *(LONGSIZ32*)&, chan)
#define	SET_MOD_FLOAT(s, r, c)	SET(s, r, c, FLOATSIZ32, %g, *(LONGSIZ32*)&, mod)
#define	SET_CHAN_LONG(s, r, c)	SET(s, r, c, LONGSIZ32, %ld, (LONGSIZ32), chan)
#define	SET_MOD_LONG(s, r, c)	SET(s, r, c, LONGSIZ32, %ld, (LONGSIZ32), mod)

#define SET_GEN_MOD_FLOAT(str, reg, cmd, lmin, lmax, errn)\
  SET_GEN(str, reg, cmd, FLOATSIZ32, %g, *(LONGSIZ32*)&, mod, lmin, lmax, errn)
#define	SET_GEN_MOD_LONG(str, reg, cmd, lmin, lmax, errn)\
  SET_GEN(str, reg, cmd, LONGSIZ32, %ld, (LONGSIZ32), mod, lmin, lmax, errn)
    

/* Module parameters */
GET_MOD_SHORT(append_status, E1432_APPEND_STATUS_REG)
SET_MOD_SHORT(append_status, E1432_APPEND_STATUS_REG, E1432_CMD_SET_APPEND_STATUS)
GET_MOD_SHORT(arm_mode, E1432_ARM_MODE_REG)
SET_MOD_SHORT(arm_mode, E1432_ARM_MODE_REG, E1432_CMD_SET_ARM_MODE)
GET_MOD_FLOAT(arm_time_interval, E1432_ARM_TIME_INTERVAL_REG)
GET_FIXED_LIMITS(arm_time_interval, E1432_ARM_TIME_INTERVAL_MIN,
  E1432_ARM_TIME_INTERVAL_MAX, E1432_ARM_TIME_INTERVAL_DEF, 0)
SET_GEN_MOD_FLOAT(arm_time_interval, E1432_ARM_TIME_INTERVAL_REG,
  E1432_CMD_SET_ARM_TIME_INTERVAL, E1432_ARM_TIME_INTERVAL_MIN,
  E1432_ARM_TIME_INTERVAL_MAX, ERR1432_ILLEGAL_ARM_TIME_INTERVAL)
GET_MOD_SHORT(auto_arm, E1432_ARM_MODE_REG) /*Obsolete*/
SET_MOD_SHORT(auto_arm, E1432_ARM_MODE_REG, E1432_CMD_SET_ARM_MODE) /* Obsolete */
GET_MOD_SHORT(auto_trigger, E1432_AUTO_TRIGGER_REG)
SET_MOD_SHORT(auto_trigger, E1432_AUTO_TRIGGER_REG, E1432_CMD_SET_AUTO_TRIGGER)
GET_MOD_SHORT(avg_mode, E1432_AVG_MODE_REG)
SET_MOD_SHORT(avg_mode, E1432_AVG_MODE_REG, E1432_CMD_SET_AVG_MODE)
GET_MOD_LONG(avg_number, E1432_AVG_NUMBER_REG)
GET_FIXED_LIMITS(avg_number, E1432_AVG_NUMBER_MIN, E1432_AVG_NUMBER_MAX,
  E1432_AVG_NUMBER_DEF, -1)
SET_GEN_MOD_LONG(avg_number, E1432_AVG_NUMBER_REG, E1432_CMD_SET_AVG_NUMBER,
  E1432_AVG_NUMBER_MIN, E1432_AVG_NUMBER_MAX, ERR1432_ILLEGAL_AVG_NUMBER)
GET_MOD_LONG(avg_update, E1432_AVG_UPDATE_REG)
GET_FIXED_LIMITS(avg_update, E1432_AVG_UPDATE_MIN, E1432_AVG_UPDATE_MAX,
  E1432_AVG_UPDATE_DEF, -1)
SET_GEN_MOD_LONG(avg_update, E1432_AVG_UPDATE_REG, E1432_CMD_SET_AVG_UPDATE,
  E1432_AVG_UPDATE_MIN, E1432_AVG_UPDATE_MAX, ERR1432_ILLEGAL_AVG_UPDATE)
GET_MOD_FLOAT(avg_weight, E1432_AVG_WEIGHT_REG)
GET_FIXED_LIMITS(avg_weight, E1432_AVG_WEIGHT_MIN, E1432_AVG_WEIGHT_MAX,
  E1432_AVG_WEIGHT_DEF, -1)
SET_GEN_MOD_FLOAT(avg_weight, E1432_AVG_WEIGHT_REG, E1432_CMD_SET_AVG_WEIGHT,
  E1432_AVG_WEIGHT_MIN, E1432_AVG_WEIGHT_MAX, ERR1432_ILLEGAL_AVG_WEIGHT)
GET_MOD_LONG(blocksize, E1432_BLOCKSIZE_REG)
GET_MOD_LIMITS(blocksize, E1432_CMD_LGET_BLOCKSIZE)
SET_MOD_LONG(blocksize, E1432_BLOCKSIZE_REG, E1432_CMD_SET_BLOCKSIZE)
GET_MOD_SHORT(cal_dac, E1432_CAL_DAC_REG)
GET_FIXED_LIMITS(cal_dac, E1432_CAL_DAC_MIN, E1432_CAL_DAC_MAX,
  E1432_CAL_DAC_DEF, 1)
SET_MOD_SHORT(cal_dac, E1432_CAL_DAC_REG, E1432_CMD_SET_CAL_DAC)
GET_MOD_FLOAT(cal_voltage, E1432_CAL_VOLTAGE_REG)
GET_FIXED_LIMITS(cal_voltage, E1432_CAL_VOLTAGE_MIN, E1432_CAL_VOLTAGE_MAX,
  E1432_CAL_VOLTAGE_DEF, -1)
SET_MOD_FLOAT(cal_voltage, E1432_CAL_VOLTAGE_REG, E1432_CMD_SET_CAL_VOLTAGE)
GET_MOD_SHORT(calin, E1432_CALIN_REG)
SET_MOD_SHORT(calin, E1432_CALIN_REG, E1432_CMD_SET_CALIN)
GET_MOD_FLOAT(center_freq, E1432_CENTER_FREQ_REG)
GET_FIXED_LIMITS(center_freq, E1432_CENTER_FREQ_MIN, E1432_CENTER_FREQ_MAX,
  E1432_CENTER_FREQ_DEF, 0)
SET_GEN_MOD_FLOAT(center_freq, E1432_CENTER_FREQ_REG,
  E1432_CMD_SET_CENTER_FREQ, E1432_CENTER_FREQ_MIN,
  E1432_CENTER_FREQ_MAX, ERR1432_ILLEGAL_CENTER_FREQ)
GET_MOD_FLOAT(clock_freq, E1432_CLOCK_FREQ_REG)
GET_FIXED_LIMITS(clock_freq, E1432_CLOCK_FREQ_MIN, E1432_CLOCK_FREQ_MAX,
  E1432_CLOCK_FREQ_DEF, 0)
SET_MOD_FLOAT(clock_freq, E1432_CLOCK_FREQ_REG, E1432_CMD_SET_CLOCK_FREQ)
GET_MOD_SHORT(clock_master, E1432_CLOCK_MASTER_REG)
SET_MOD_SHORT(clock_master, E1432_CLOCK_MASTER_REG, E1432_CMD_SET_CLOCK_MASTER)
GET_MOD_SHORT(clock_source, E1432_CLOCK_SOURCE_REG)
SET_MOD_SHORT(clock_source, E1432_CLOCK_SOURCE_REG, E1432_CMD_SET_CLOCK_SOURCE)
GET_MOD_SHORT(data_mode, E1432_DATA_MODE_REG)
SET_MOD_SHORT(data_mode, E1432_DATA_MODE_REG, E1432_CMD_SET_DATA_MODE)
GET_MOD_SHORT(data_port, E1432_DATA_PORT_REG)
SET_MOD_SHORT(data_port, E1432_DATA_PORT_REG, E1432_CMD_SET_DATA_PORT)
GET_MOD_SHORT(data_size, E1432_DATA_SIZE_REG)
SET_MOD_SHORT(data_size, E1432_DATA_SIZE_REG, E1432_CMD_SET_DATA_SIZE)
GET_MOD_SHORT(decimation_output, E1432_DECIMATION_OUTPUT_REG)
SET_MOD_SHORT(decimation_output, E1432_DECIMATION_OUTPUT_REG, E1432_CMD_SET_DECIMATION_OUTPUT)
GET_MOD_SHORT(decimation_oversample, E1432_DECIMATION_OVERSAMPLE_REG)
SET_MOD_SHORT(decimation_oversample, E1432_DECIMATION_OVERSAMPLE_REG, E1432_CMD_SET_DECIMATION_OVERSAMPLE)
GET_MOD_SHORT(decimation_undersamp, E1432_DECIMATION_UNDERSAMP_REG)
#ifndef HPVXI_DOWNLOAD
/* appears to result in a symbol too long for as68k */
GET_FIXED_LIMITS(decimation_undersamp, E1432_DECIMATION_UNDERSAMP_MIN,
  E1432_DECIMATION_UNDERSAMP_MAX, E1432_DECIMATION_UNDERSAMP_DEF, -1)
#endif /* HPVXI_DOWNLOAD */
SET_MOD_SHORT(decimation_undersamp, E1432_DECIMATION_UNDERSAMP_REG, E1432_CMD_SET_DECIMATION_UNDERSAMP)
GET_MOD_FLOAT(delta_order, E1432_DELTA_ORDER_REG)
GET_FIXED_LIMITS(delta_order, E1432_DELTA_ORDER_MIN, E1432_DELTA_ORDER_MAX,
  E1432_DELTA_ORDER_DEF, 0)
SET_MOD_FLOAT(delta_order, E1432_DELTA_ORDER_REG, E1432_CMD_SET_DELTA_ORDER)
GET_MOD_LONG(fifo_size, E1432_FIFO_SIZE_REG)
GET_MOD_LIMITS(fifo_size, E1432_CMD_LGET_FIFO_SIZE)
SET_MOD_LONG(fifo_size, E1432_FIFO_SIZE_REG, E1432_CMD_SET_FIFO_SIZE)
GET_MOD_FLOAT(filter_settling_time, E1432_FILTER_SETTLING_TIME_REG)
GET_MOD_FLOAT(hpf_span, E1432_HPF_SPAN_REG)
GET_FIXED_LIMITS(hpf_span, E1432_HPF_SPAN_MIN, E1432_HPF_SPAN_MAX,
  E1432_HPF_SPAN_DEF, -1)
SET_MOD_FLOAT(hpf_span, E1432_HPF_SPAN_REG, E1432_CMD_SET_HPF_SPAN)
#ifndef HPVXI_DOWNLOAD
/* appears to result in a symbol too long for as68k */
GET_FIXED_LIMITS(filter_settling_time, E1432_FILTER_SETTLING_MIN,
  E1432_FILTER_SETTLING_MAX, E1432_FILTER_SETTLING_DEF, 1)
#endif /* HPVXI_DOWNLOAD */
SET_GEN_MOD_FLOAT(filter_settling_time, E1432_FILTER_SETTLING_TIME_REG,
  E1432_CMD_SET_FILTER_SETTLING_TIME, E1432_FILTER_SETTLING_MIN,
  E1432_FILTER_SETTLING_MAX, ERR1432_ILLEGAL_SETTLING_TIME)
GET_MOD_LONG(internal_debug, E1432_INTERNAL_DEBUG_REG)
GET_FIXED_LIMITS(internal_debug, E1432_INTERNAL_DEBUG_MIN,
  E1432_INTERNAL_DEBUG_MAX, E1432_INTERNAL_DEBUG_DEF, 1)
SET_MOD_LONG(internal_debug, E1432_INTERNAL_DEBUG_REG, E1432_CMD_SET_INTERNAL_DEBUG)
GET_MOD_SHORT(interrupt_mask, E1432_INTERRUPT_MASK_REG)
/* e1432_set_interrupt_mask is in intr.c */
GET_MOD_SHORT(interrupt_priority, E1432_INTERRUPT_PRIORITY_REG)
GET_FIXED_LIMITS(interrupt_priority, E1432_IRQ_PRIORITY_NONE,
  E1432_IRQ_PRIORITY_MAX, E1432_IRQ_PRIORITY_DEF, 1)
GET_MOD_LONG(tach_irq_number, E1432_TACH_IRQ_NUMBER_REG)
GET_FIXED_LIMITS(tach_irq_number, E1432_TACH_IRQ_NUMBER_MIN,
  E1432_TACH_IRQ_NUMBER_MAX, E1432_TACH_IRQ_NUMBER_DEF, 1)
SET_GEN_MOD_LONG(tach_irq_number, E1432_TACH_IRQ_NUMBER_REG,
  E1432_CMD_SET_TACH_IRQ_NUMBER, E1432_TACH_IRQ_NUMBER_MIN,
  E1432_TACH_IRQ_NUMBER_MAX, ERR1432_ILLEGAL_TACH_IRQ_NUMBER)
/* e1432_set_interrupt_priority is in intr.c */
GET_MOD_SHORT(lbus_mode, E1432_LBUS_MODE_REG)
SET_MOD_SHORT(lbus_mode, E1432_LBUS_MODE_REG, E1432_CMD_SET_LBUS_MODE)
GET_MOD_SHORT(lbus_reset, E1432_LBUS_RESET_REG)
/* Badly named function, doesn't fit into our scheme. */
SHORTSIZ16 EXPORT
e1432_reset_lbus(E1432ID hw, SHORTSIZ16 ID, SHORTSIZ16 value)
{
    TRACE_PRINTF(0, ("e1432_reset_lbus(0x%p, %d, %d)\n",
		     hw, ID, value));
    return i1432_set_mod(hw, ID, E1432_LBUS_RESET_REG,
			 E1432_CMD_SET_LBUS_RESET, value);
}
GET_MOD_FLOAT(max_order, E1432_MAX_ORDER_REG)
GET_FIXED_LIMITS(max_order, E1432_MAX_ORDER_MIN, E1432_MAX_ORDER_MAX,
  E1432_MAX_ORDER_DEF, 0)
SET_MOD_FLOAT(max_order, E1432_MAX_ORDER_REG, E1432_CMD_SET_MAX_ORDER)
GET_MOD_FLOAT(meas_time_length, E1432_MEAS_TIME_LENGTH_REG)
GET_FIXED_LIMITS(meas_time_length, E1432_MEAS_TIME_LENGTH_MIN,
  E1432_MEAS_TIME_LENGTH_MAX, E1432_MEAS_TIME_LENGTH_DEF, 0)
SET_MOD_FLOAT(meas_time_length, E1432_MEAS_TIME_LENGTH_REG, E1432_CMD_SET_MEAS_TIME_LENGTH)
GET_MOD_LONG(mmf_delay, E1432_MMF_DELAY_REG)
SET_MOD_LONG(mmf_delay, E1432_MMF_DELAY_REG, E1432_CMD_SET_MMF_DELAY)
GET_MOD_SHORT(multi_sync, E1432_MULTI_SYNC_REG)
SET_MOD_SHORT(multi_sync, E1432_MULTI_SYNC_REG, E1432_CMD_SET_MULTI_SYNC)
GET_MOD_LONG(overlap, E1432_OVERLAP_REG)
GET_MOD_LIMITS(overlap, E1432_CMD_LGET_OVERLAP)
GET_MOD_SHORT(octave_avg_mode, E1432_OCTAVE_AVG_MODE_REG)
GET_MOD_LONG(octave_blocksize, E1432_OCTAVE_BLOCKSIZE_REG)
GET_MOD_SHORT(octave_hold_mode, E1432_OCTAVE_HOLD_MODE_REG)
GET_MOD_FLOAT(octave_int_time, E1432_OCTAVE_INT_TIME_REG)
GET_FIXED_LIMITS(octave_int_time, E1432_OCTAVE_INT_TIME_MIN,
  E1432_OCTAVE_INT_TIME_MAX, E1432_OCTAVE_INT_TIME_DEF,
  E1432_OCTAVE_INT_TIME_STEP)
GET_MOD_SHORT(octave_mode, E1432_OCTAVE_MODE_REG)
GET_FIXED_LIMITS(octave_start_freq, E1432_OCTAVE_START_FREQ_MIN,
  E1432_OCTAVE_START_FREQ_MAX, E1432_OCTAVE_START_FREQ_DEF, 1)
GET_FIXED_LIMITS(octave_stop_freq, E1432_OCTAVE_STOP_FREQ_MIN,
  E1432_OCTAVE_STOP_FREQ_MAX, E1432_OCTAVE_STOP_FREQ_DEF, 1)
GET_MOD_FLOAT(octave_time_const, E1432_OCTAVE_TIME_CONST_REG)
GET_FIXED_LIMITS(octave_time_const, E1432_OCTAVE_TIME_CONST_MIN,
  E1432_OCTAVE_TIME_CONST_MAX, E1432_OCTAVE_TIME_CONST_DEF,
  E1432_OCTAVE_TIME_CONST_STEP)
GET_MOD_FLOAT(octave_time_step, E1432_OCTAVE_TIME_STEP_REG)
GET_FIXED_LIMITS(octave_time_step, E1432_OCTAVE_TIME_STEP_MIN,
  E1432_OCTAVE_TIME_STEP_MAX, E1432_OCTAVE_TIME_STEP_DEF,
  E1432_OCTAVE_TIME_STEP_STEP)
SET_MOD_LONG(overlap, E1432_OVERLAP_REG, E1432_CMD_SET_OVERLAP)
GET_MOD_FLOAT(peak_decay_time, E1432_PEAK_DECAY_TIME_REG)
GET_FIXED_LIMITS(peak_decay_time, E1432_PEAK_DECAY_TIME_MIN,
  E1432_PEAK_DECAY_TIME_MAX, E1432_PEAK_DECAY_TIME_DEF, -1)
SET_GEN_MOD_FLOAT(peak_decay_time, E1432_PEAK_DECAY_TIME_REG,
  E1432_CMD_SET_PEAK_DECAY_TIME, E1432_PEAK_DECAY_TIME_MIN,
  E1432_PEAK_DECAY_TIME_MAX, ERR1432_ILLEGAL_PEAK_DECAY_TIME)
GET_MOD_FLOAT(peak_hold_time, E1432_PEAK_HOLD_TIME_REG)
GET_FIXED_LIMITS(peak_hold_time, E1432_PEAK_HOLD_TIME_MIN,
  E1432_PEAK_HOLD_TIME_MAX, E1432_PEAK_HOLD_TIME_DEF, -1)
SET_MOD_FLOAT(peak_hold_time, -1, E1432_CMD_SET_PEAK_HOLD_TIME) /* force recalculation */
GET_MOD_FLOAT(peak_span, E1432_PEAK_SPAN_REG)
GET_FIXED_LIMITS(peak_span, E1432_PEAK_SPAN_MIN, E1432_PEAK_SPAN_MAX,
  E1432_PEAK_SPAN_DEF, -1)
SET_MOD_FLOAT(peak_span, E1432_PEAK_SPAN_REG, E1432_CMD_SET_PEAK_SPAN)
GET_MOD_SHORT(pre_arm_mode, E1432_PRE_ARM_MODE_REG)
SET_MOD_SHORT(pre_arm_mode, E1432_PRE_ARM_MODE_REG, E1432_CMD_SET_PRE_ARM_MODE)
GET_MOD_SHORT(ramp, E1432_RAMP_REG)
SET_MOD_SHORT(ramp, E1432_RAMP_REG, E1432_CMD_SET_RAMP)
GET_MOD_FLOAT(rms_avg_time, E1432_RMS_AVG_TIME_REG)
GET_FIXED_LIMITS(rms_avg_time, E1432_RMS_AVG_TIME_MIN, E1432_RMS_AVG_TIME_MAX,
  E1432_RMS_AVG_TIME_DEF, -1)
SET_GEN_MOD_FLOAT(rms_avg_time, E1432_RMS_AVG_TIME_REG,
  E1432_CMD_SET_RMS_AVG_TIME, E1432_RMS_AVG_TIME_MIN,
  E1432_RMS_AVG_TIME_MAX, ERR1432_ILLEGAL_RMS_AVG_TIME)
GET_MOD_FLOAT(rms_decay_time, E1432_RMS_DECAY_TIME_REG)
GET_FIXED_LIMITS(rms_decay_time, E1432_RMS_DECAY_TIME_MIN,
  E1432_RMS_DECAY_TIME_MAX, E1432_RMS_DECAY_TIME_DEF, -1)
SET_MOD_FLOAT(rms_decay_time, -1, E1432_CMD_SET_RMS_DECAY_TIME) /* force recalculation */
GET_MOD_FLOAT(rms_span, E1432_RMS_SPAN_REG)
GET_FIXED_LIMITS(rms_span, E1432_RMS_SPAN_MIN, E1432_RMS_SPAN_MAX,
  E1432_RMS_SPAN_DEF, -1)
SET_MOD_FLOAT(rms_span, E1432_RMS_SPAN_REG, E1432_CMD_SET_RMS_SPAN)
GET_MOD_SHORT(sample_mode, E1432_SAMPLE_MODE_REG)
SET_MOD_SHORT(sample_mode, E1432_SAMPLE_MODE_REG, E1432_CMD_SET_SAMPLE_MODE)
GET_MOD_FLOAT(span, E1432_SPAN_REG)
GET_FIXED_LIMITS(span, E1432_SPAN_MIN, E1432_SPAN_MAX, E1432_SPAN_DEF, -1)
SET_GEN_MOD_FLOAT(span, E1432_SPAN_REG, E1432_CMD_SET_SPAN,
  E1432_SPAN_MIN, E1432_SPAN_MAX, ERR1432_ILLEGAL_SPAN)
GET_MOD_SHORT(sumbus, E1432_SUMBUS_REG)
SET_MOD_SHORT(sumbus, E1432_SUMBUS_REG, E1432_CMD_SET_SUMBUS)
GET_MOD_SHORT(peak_mode, E1432_PEAK_MODE_REG)
GET_MOD_SHORT(rms_mode, E1432_RMS_MODE_REG)
GET_MOD_LONG(trigger_delay, E1432_TRIGGER_DELAY_REG)
GET_MOD_LIMITS(trigger_delay, E1432_CMD_LGET_TRIGGER_DELAY)
SET_MOD_LONG(trigger_delay, E1432_TRIGGER_DELAY_REG, E1432_CMD_SET_TRIGGER_DELAY)
GET_MOD_SHORT(trigger_ext, E1432_TRIGGER_EXT_REG)
SET_MOD_SHORT(trigger_ext, E1432_TRIGGER_EXT_REG, E1432_CMD_SET_TRIGGER_EXT)
GET_MOD_LONG(trigger_flag, E1432_TRIGGER_FLAG_REG)
SET_MOD_LONG(trigger_flag, E1432_TRIGGER_FLAG_REG, E1432_CMD_SET_TRIGGER_FLAG)
GET_MOD_LONG(trig_hi, E1432_TRIG_HI_REG)
SET_MOD_LONG(trig_hi, -1, E1432_CMD_SET_TRIG_HI)
GET_MOD_LONG(trig_lo, E1432_TRIG_LO_REG)
SET_MOD_LONG(trig_lo, -1, E1432_CMD_SET_TRIG_LO)
GET_MOD_SHORT(trigger_master, E1432_TRIGGER_MASTER_REG)
/* e1432_set_trigger_master is in trigger.c */
GET_MOD_LONG(triggers_per_arm, E1432_TRIGGERS_PER_ARM_REG)
GET_FIXED_LIMITS(triggers_per_arm, E1432_TRIGGERS_PER_ARM_MIN,
  E1432_TRIGGERS_PER_ARM_MAX, E1432_TRIGGERS_PER_ARM_DEF, 1)
SET_GEN_MOD_LONG(triggers_per_arm, E1432_TRIGGERS_PER_ARM_REG,
  E1432_CMD_SET_TRIGGERS_PER_ARM, E1432_TRIGGERS_PER_ARM_MIN,
  E1432_TRIGGERS_PER_ARM_MAX, ERR1432_ILLEGAL_TRIGGERS_PER_ARM)
GET_MOD_SHORT(ttltrg_clock, E1432_TTLTRG_CLOCK_REG)
SET_MOD_SHORT(ttltrg_clock, E1432_TTLTRG_CLOCK_REG, E1432_CMD_SET_TTLTRG_CLOCK)
GET_MOD_SHORT(ttltrg_gclock, E1432_TTLTRG_GCLOCK_REG)
SET_MOD_SHORT(ttltrg_gclock, E1432_TTLTRG_GCLOCK_REG, E1432_CMD_SET_TTLTRG_GCLOCK)
GET_MOD_SHORT(ttltrg_satrg, E1432_TTLTRG_SATRG_REG)
SET_MOD_SHORT(ttltrg_satrg, E1432_TTLTRG_SATRG_REG, E1432_CMD_SET_TTLTRG_SATRG)
GET_MOD_SHORT(ttltrg_trigger, E1432_TTLTRG_TRIGGER_REG)
SET_MOD_SHORT(ttltrg_trigger, E1432_TTLTRG_TRIGGER_REG, E1432_CMD_SET_TTLTRG_TRIGGER)
GET_MOD_LONG(user_decimation, E1432_USER_DECIMATION_REG)
SET_GEN_MOD_LONG(user_decimation, E1432_USER_DECIMATION_REG,
  E1432_CMD_SET_USER_DECIMATION, E1432_USER_DECIMATION_MIN,
  E1432_USER_DECIMATION_MAX, ERR1432_ILLEGAL_USER_DECIMATION)
GET_MOD_LONG(user_frames_per_block, E1432_USER_FRAMES_PER_BLOCK_REG)
SET_GEN_MOD_LONG(user_frames_per_block, E1432_USER_FRAMES_PER_BLOCK_REG,
  E1432_CMD_SET_USER_FRAMES_PER_BLOCK, E1432_USER_FRAMES_PER_BLOCK_MIN,
  E1432_USER_FRAMES_PER_BLOCK_MAX, ERR1432_ILLEGAL_USER_FRAMES_PER_BLOCK)
GET_MOD_SHORT(window, E1432_WINDOW_REG)
SET_MOD_SHORT(window, E1432_WINDOW_REG, E1432_CMD_SET_WINDOW)
GET_MOD_LONG(xfer_size, E1432_XFER_SIZE_REG)
GET_MOD_LIMITS(xfer_size, E1432_CMD_LGET_XFER_SIZE)
SET_MOD_LONG(xfer_size, E1432_XFER_SIZE_REG, E1432_CMD_SET_XFER_SIZE)
GET_MOD_SHORT(zoom, E1432_ZOOM_REG)
SET_MOD_SHORT(zoom, E1432_ZOOM_REG, E1432_CMD_SET_ZOOM)

/* Non-settable module info */
GET_MOD_LONG(decimation, E1432_DECIMATION_REG)
GET_MOD_LONG(samples_to_pre_arm, E1432_SAMPLES_TO_PRE_ARM_REG)
GET_MOD_FLOAT(trig_corr, E1432_TRIG_CORR_REG)
GET_MOD_FLOAT(tach_clock_freq, E1432_TACH_CLOCK_FREQ_REG)
GET_MOD_FLOAT(tach_delay, E1432_TACH_DELAY_REG)

/* Channel parameters */
GET_CHAN_SHORT(active, E1432_ACTIVE_CREG)
/* e1432_set_active is in modgroup.c */
GET_CHAN_FLOAT(amp_scale, E1432_AMP_SCALE_CREG)
GET_CHAN_LIMITS(amp_scale, E1432_LIM_SCA_AMP_SCALE)
SET_CHAN_FLOAT(amp_scale, -1, E1432_CCMD_SET_AMP_SCALE)
GET_CHAN_SHORT(anti_alias_analog, E1432_ANTI_ALIAS_ANALOG_CREG)
SET_CHAN_SHORT(anti_alias_analog, E1432_ANTI_ALIAS_ANALOG_CREG, E1432_CCMD_SET_ANTI_ALIAS_ANALOG)
GET_CHAN_SHORT(anti_alias_digital, E1432_ANTI_ALIAS_DIGITAL_CREG)
SET_CHAN_SHORT(anti_alias_digital, E1432_ANTI_ALIAS_DIGITAL_CREG, E1432_CCMD_SET_ANTI_ALIAS_DIGITAL)
GET_CHAN_SHORT(arm_channel_per_input, E1432_ARM_CHANNEL_PER_INPUT_CREG)
GET_CHAN_FLOAT(autozero_offset, E1432_AUTOZERO_OFFSET_CREG)
GET_CHAN_LIMITS(autozero_offset, E1432_LIM_SCA_AUTOZERO_OFFSET)
SET_CHAN_FLOAT(autozero_offset, E1432_AUTOZERO_OFFSET_CREG, E1432_CCMD_SET_AUTOZERO_OFFSET)
GET_CHAN_SHORT(calc_data, E1432_CALC_DATA_CREG)
SET_CHAN_SHORT(calc_data, E1432_CALC_DATA_CREG, E1432_CCMD_SET_CALC_DATA)
GET_CHAN_SHORT(coupling, E1432_COUPLING_CREG)
SET_CHAN_SHORT(coupling, E1432_COUPLING_CREG, E1432_CCMD_SET_COUPLING)
GET_CHAN_FLOAT(coupling_freq, E1432_COUPLING_FREQ_CREG)
GET_CHAN_LIMITS(coupling_freq, E1432_LIM_SCA_COUPLING_FREQ)
SET_CHAN_FLOAT(coupling_freq, E1432_COUPLING_FREQ_CREG, E1432_CCMD_SET_COUPLING_FREQ)
GET_CHAN_FLOAT(duty_cycle, E1432_DUTY_CYCLE_CREG)
GET_CHAN_LIMITS(duty_cycle, E1432_LIM_SCA_DUTY_CYCLE)
SET_CHAN_FLOAT(duty_cycle, E1432_DUTY_CYCLE_CREG, E1432_CCMD_SET_DUTY_CYCLE)
GET_CHAN_FLOAT(filter_freq, E1432_FILTER_FREQ_CREG)
GET_CHAN_LIMITS(filter_freq, E1432_LIM_SCA_FILTER_FREQ)
SET_CHAN_FLOAT(filter_freq, E1432_FILTER_FREQ_CREG, E1432_CCMD_SET_FILTER_FREQ)
GET_CHAN_SHORT(input_high, E1432_INPUT_HIGH_CREG)
SET_CHAN_SHORT(input_high, E1432_INPUT_HIGH_CREG, E1432_CCMD_SET_INPUT_HIGH)
GET_CHAN_SHORT(input_low, E1432_INPUT_LOW_CREG)
SET_CHAN_SHORT(input_low, E1432_INPUT_LOW_CREG, E1432_CCMD_SET_INPUT_LOW)
GET_CHAN_SHORT(input_mode, E1432_MODE_CREG) /* Note name */
SET_CHAN_SHORT(input_mode, E1432_MODE_CREG, E1432_CCMD_SET_MODE) /* Note name */
GET_CHAN_FLOAT(input_offset, E1432_INPUT_OFFSET_CREG)
GET_CHAN_LIMITS(input_offset, E1432_LIM_SCA_INPUT_OFFSET)
SET_CHAN_FLOAT(input_offset, E1432_INPUT_OFFSET_CREG, E1432_CCMD_SET_INPUT_OFFSET)
GET_CHAN_FLOAT(pre_arm_rpm, E1432_PRE_ARM_RPM_CREG)
GET_CHAN_LIMITS(pre_arm_rpm, E1432_LIM_SCA_PRE_ARM_RPM)
SET_CHAN_FLOAT(pre_arm_rpm, E1432_PRE_ARM_RPM_CREG, E1432_CCMD_SET_PRE_ARM_RPM)
GET_CHAN_FLOAT(ramp_rate, E1432_RAMP_RATE_CREG)
GET_CHAN_LIMITS(ramp_rate, E1432_LIM_SCA_RAMP_RATE)
SET_CHAN_FLOAT(ramp_rate, E1432_RAMP_RATE_CREG, E1432_CCMD_SET_RAMP_RATE)
GET_CHAN_FLOAT(range, E1432_RANGE_CREG)
GET_CHAN_LIMITS(range, E1432_LIM_SCA_RANGE)
SET_CHAN_FLOAT(range, E1432_RANGE_CREG, E1432_CCMD_SET_RANGE)
GET_CHAN_FLOAT(range_charge, E1432_RANGE_CHARGE_CREG)
GET_CHAN_LIMITS(range_charge, E1432_LIM_SCA_RANGE_CHARGE)
SET_CHAN_FLOAT(range_charge, E1432_RANGE_CHARGE_CREG, E1432_CCMD_SET_RANGE_CHARGE)
GET_CHAN_FLOAT(range_mike, E1432_RANGE_MIKE_CREG)
GET_CHAN_LIMITS(range_mike, E1432_LIM_SCA_RANGE_MIKE)
SET_CHAN_FLOAT(range_mike, E1432_RANGE_MIKE_CREG, E1432_CCMD_SET_RANGE_MIKE)
GET_MOD_LONG(raw_tach_size, E1432_RAW_TACH_SIZE_REG)
GET_CHAN_FLOAT(rpm_high, E1432_RPM_HIGH_CREG)
GET_CHAN_LIMITS(rpm_high, E1432_LIM_SCA_RPM_HIGH)
SET_CHAN_FLOAT(rpm_high, E1432_RPM_HIGH_CREG, E1432_CCMD_SET_RPM_HIGH)
GET_CHAN_FLOAT(rpm_interval, E1432_RPM_INTERVAL_CREG)
GET_CHAN_LIMITS(rpm_interval, E1432_LIM_SCA_RPM_INTERVAL)
SET_CHAN_FLOAT(rpm_interval, E1432_RPM_INTERVAL_CREG, E1432_CCMD_SET_RPM_INTERVAL)
GET_CHAN_FLOAT(rpm_low, E1432_RPM_LOW_CREG)
GET_CHAN_LIMITS(rpm_low, E1432_LIM_SCA_RPM_LOW)
SET_CHAN_FLOAT(rpm_low, E1432_RPM_LOW_CREG, E1432_CCMD_SET_RPM_LOW)
GET_CHAN_FLOAT(rpm_smoothing, E1432_RPM_SMOOTHING_CREG)
GET_CHAN_LIMITS(rpm_smoothing, E1432_LIM_SCA_RPM_SMOOTHING)
SET_CHAN_FLOAT(rpm_smoothing, E1432_RPM_SMOOTHING_CREG, E1432_CCMD_SET_RPM_SMOOTHING)
GET_CHAN_FLOAT(sine_freq, E1432_SINE_FREQ_CREG)
GET_CHAN_LIMITS(sine_freq, E1432_LIM_SCA_SINE_FREQ)
SET_CHAN_FLOAT(sine_freq, E1432_SINE_FREQ_CREG, E1432_CCMD_SET_SINE_FREQ)
GET_CHAN_FLOAT(sine_phase, E1432_SINE_PHASE_CREG)
GET_CHAN_LIMITS(sine_phase, E1432_LIM_SCA_SINE_PHASE)
SET_CHAN_FLOAT(sine_phase, E1432_SINE_PHASE_CREG, E1432_CCMD_SET_SINE_PHASE)
GET_CHAN_LONG(source_blocksize, E1432_SOURCE_BLOCKSIZE_CREG)
GET_CHAN_LIMITS(source_blocksize, E1432_LIM_SCA_SOURCE_BLOCKSIZE)
SET_CHAN_LONG(source_blocksize, E1432_SOURCE_BLOCKSIZE_CREG, E1432_CCMD_SET_SOURCE_BLOCKSIZE)
GET_CHAN_FLOAT(source_centerfreq, E1432_SOURCE_CENTERFREQ_CREG)
GET_CHAN_LIMITS(source_centerfreq, E1432_LIM_SCA_SOURCE_CENTERFREQ)
SET_CHAN_FLOAT(source_centerfreq, E1432_SOURCE_CENTERFREQ_CREG, E1432_CCMD_SET_SOURCE_CENTERFREQ)
GET_CHAN_SHORT(source_cola, E1432_SOURCE_COLA_CREG)
SET_CHAN_SHORT(source_cola, E1432_SOURCE_COLA_CREG, E1432_CCMD_SET_SOURCE_COLA)
GET_CHAN_SHORT(source_mode, E1432_MODE_CREG) /* Note name */
SET_CHAN_SHORT(source_mode, -1, E1432_CCMD_SET_MODE) /* Note name */
GET_CHAN_SHORT(source_output, E1432_SOURCE_OUTPUT_CREG)
SET_CHAN_SHORT(source_output, E1432_SOURCE_OUTPUT_CREG, E1432_CCMD_SET_SOURCE_OUTPUT)
GET_CHAN_SHORT(source_seed, E1432_SOURCE_SEED_CREG)
GET_CHAN_LIMITS(source_seed, E1432_LIM_SCA_SOURCE_SEED)
SET_CHAN_SHORT(source_seed, E1432_SOURCE_SEED_CREG, E1432_CCMD_SET_SOURCE_SEED)
GET_CHAN_FLOAT(source_span, E1432_SOURCE_SPAN_CREG)
GET_CHAN_LIMITS(source_span, E1432_LIM_SCA_SOURCE_SPAN)
SET_CHAN_FLOAT(source_span, E1432_SOURCE_SPAN_CREG, E1432_CCMD_SET_SOURCE_SPAN)
GET_CHAN_SHORT(source_sum, E1432_SOURCE_SUM_CREG)
SET_CHAN_SHORT(source_sum, E1432_SOURCE_SUM_CREG, E1432_CCMD_SET_SOURCE_SUM)
GET_CHAN_LONG(srcbuffer_size, E1432_SRCBUFFER_SIZE_CREG)
GET_CHAN_LIMITS(srcbuffer_size, E1432_LIM_SCA_SRCBUFFER_SIZE)
SET_CHAN_LONG(srcbuffer_size, -1, E1432_CCMD_SET_SRCBUFFER_SIZE)
GET_CHAN_SHORT(srcbuffer_mode, E1432_SRCBUFFER_MODE_CREG)
SET_CHAN_SHORT(srcbuffer_mode, E1432_SRCBUFFER_MODE_CREG, E1432_CCMD_SET_SRCBUFFER_MODE)
GET_CHAN_SHORT(srcbuffer_init, E1432_SRCBUFFER_INIT_CREG)
SET_CHAN_SHORT(srcbuffer_init, -1, E1432_CCMD_SET_SRCBUFFER_INIT)
GET_CHAN_LONG(srcparm_mode, E1432_SRCPARM_MODE_CREG)
SET_CHAN_LONG(srcparm_mode, E1432_SRCPARM_MODE_CREG, E1432_CCMD_SET_SRCPARM_MODE)
GET_CHAN_SHORT(srcoff_mode, E1432_SRCOFF_MODE_CREG)
SET_CHAN_SHORT(srcoff_mode, E1432_SRCOFF_MODE_CREG, E1432_CCMD_SET_SRCOFF_MODE)
GET_CHAN_LONG(tach_decimate, E1432_TACH_DECIMATE_CREG)
GET_CHAN_LIMITS(tach_decimate, E1432_LIM_SCA_TACH_DECIMATE)
SET_CHAN_LONG(tach_decimate, E1432_TACH_DECIMATE_CREG, E1432_CCMD_SET_TACH_DECIMATE)
GET_CHAN_FLOAT(tach_holdoff, E1432_TACH_HOLDOFF_CREG)
GET_CHAN_LIMITS(tach_holdoff, E1432_LIM_SCA_TACH_HOLDOFF)
SET_CHAN_FLOAT(tach_holdoff, E1432_TACH_HOLDOFF_CREG, E1432_CCMD_SET_TACH_HOLDOFF)
GET_CHAN_FLOAT(tach_max_time, E1432_TACH_MAX_TIME_CREG)
GET_CHAN_LIMITS(tach_max_time, E1432_LIM_SCA_TACH_MAX_TIME)
SET_CHAN_FLOAT(tach_max_time, E1432_TACH_MAX_TIME_CREG, E1432_CCMD_SET_TACH_MAX_TIME)
GET_CHAN_FLOAT(tach_ppr, E1432_TACH_PPR_CREG)
GET_CHAN_LIMITS(tach_ppr, E1432_LIM_SCA_TACH_PPR)
SET_CHAN_FLOAT(tach_ppr, E1432_TACH_PPR_CREG, E1432_CCMD_SET_TACH_PPR)
GET_CHAN_SHORT(trigger_channel, E1432_TRIGGER_CHANNEL_CREG)
SET_CHAN_SHORT(trigger_channel, E1432_TRIGGER_CHANNEL_CREG, E1432_CCMD_SET_TRIGGER_CHANNEL)
GET_CHAN_SHORT(trigger_mode, E1432_TRIGGER_MODE_CREG)
SET_CHAN_SHORT(trigger_mode, E1432_TRIGGER_MODE_CREG, E1432_CCMD_SET_TRIGGER_MODE)
GET_CHAN_SHORT(trigger_slope, E1432_TRIGGER_SLOPE_CREG)
SET_CHAN_SHORT(trigger_slope, E1432_TRIGGER_SLOPE_CREG, E1432_CCMD_SET_TRIGGER_SLOPE)
GET_CHAN_SHORT(weighting, E1432_WEIGHTING_CREG)
SET_CHAN_SHORT(weighting, E1432_WEIGHTING_CREG, E1432_CCMD_SET_WEIGHTING)

/* Non-settable channel info */
GET_CHAN_FLOAT(cal_offset, E1432_CAL_OFFSET_CREG)
GET_CHAN_FLOAT(cal_offset2, E1432_CAL_OFFSET2_CREG)
GET_CHAN_FLOAT(cal_gain, E1432_CAL_GAIN_CREG)
GET_CHAN_FLOAT(cal_gain2, E1432_CAL_GAIN2_CREG)
GET_CHAN_LONG(cal_failures, E1432_CAL_FAILURES_CREG)
GET_CHAN_FLOAT(current_rpm, E1432_CURRENT_RPM_CREG)
/*GET_CHAN_FLOAT(data_rpm, E1432_DATA_RPM_CREG) moved below */
GET_CHAN_FLOAT(next_arm_rpm, E1432_NEXT_ARM_RPM_CREG)

SHORTSIZ16 EXPORT
e1432_get_enable(E1432ID hw, SHORTSIZ16 ID, SHORTSIZ16 data_type,
		 SHORTSIZ16 *enable)
{
    TRACE_PRINTF(0, ("e1432_get_enable(0x%p, %d, %d, 0x%p)\n",
		     hw, ID, data_type, enable));

    if (data_type == E1432_ENABLE_TYPE_TIME)
	return i1432_get_chan_short(hw, ID, E1432_ENABLE_TIME_CREG,
				    enable);
    else if (data_type == E1432_ENABLE_TYPE_RESAMPLE)
	return i1432_get_chan_short(hw, ID, E1432_ENABLE_RESAMPLE_CREG,
				    enable);
    else if (data_type == E1432_ENABLE_TYPE_FREQ)
	return i1432_get_chan_short(hw, ID, E1432_ENABLE_FREQ_CREG,
				    enable);
    else if (data_type == E1432_ENABLE_TYPE_ORDER)
	return i1432_get_chan_short(hw, ID, E1432_ENABLE_ORDER_CREG,
				    enable);
    else if (data_type == E1432_ENABLE_TYPE_USER1)
	return i1432_get_chan_short(hw, ID, E1432_ENABLE_USER1_CREG, enable);
    else
	return i1432_id_print_error(hw, ID, ERR1432_ILLEGAL_ENABLE);
}

SHORTSIZ16 EXPORT
e1432_set_enable(E1432ID hw, SHORTSIZ16 ID, SHORTSIZ16 data_type,
		 SHORTSIZ16 enable)
{
    TRACE_PRINTF(0, ("e1432_set_enable(0x%p, %d, %d, %d)\n",
		     hw, ID, data_type, enable));

    if (data_type == E1432_ENABLE_TYPE_TIME)
	return i1432_set_chan(hw, ID, E1432_ENABLE_TIME_CREG,
			      E1432_CCMD_SET_ENABLE_TIME,
			      (LONGSIZ32) enable);
    else if (data_type == E1432_ENABLE_TYPE_RESAMPLE)
	return i1432_set_chan(hw, ID, E1432_ENABLE_RESAMPLE_CREG,
			      E1432_CCMD_SET_ENABLE_RESAMPLE,
			      (LONGSIZ32) enable);
    else if (data_type == E1432_ENABLE_TYPE_FREQ)
	return i1432_set_chan(hw, ID, E1432_ENABLE_FREQ_CREG,
			      E1432_CCMD_SET_ENABLE_FREQ,
			      (LONGSIZ32) enable);
    else if (data_type == E1432_ENABLE_TYPE_ORDER)
	return i1432_set_chan(hw, ID, E1432_ENABLE_ORDER_CREG,
			      E1432_CCMD_SET_ENABLE_ORDER,
			      (LONGSIZ32) enable);
    else if (data_type == E1432_ENABLE_TYPE_USER1)
	return i1432_set_chan(hw, ID, E1432_ENABLE_USER1_CREG,
			      E1432_CCMD_SET_ENABLE_USER1, (LONGSIZ32) enable);
    else
	return i1432_id_print_error(hw, ID, ERR1432_ILLEGAL_ENABLE);
}

SHORTSIZ16 EXPORT
e1432_get_trigger_level(E1432ID hw, SHORTSIZ16 ID, SHORTSIZ16 which,
			FLOATSIZ32 * level)
{
    TRACE_PRINTF(0, ("e1432_get_trigger_level(0x%p, %d, %d, 0x%p)\n",
		     hw, ID, which, level));

    if (which == E1432_TRIGGER_LEVEL_LOWER)
	return i1432_get_chan_float(hw, ID,
				    E1432_TRIGGER_LEVEL_LOWER_CREG,
				    level);
    else if (which == E1432_TRIGGER_LEVEL_UPPER)
	return i1432_get_chan_float(hw, ID,
				    E1432_TRIGGER_LEVEL_UPPER_CREG,
				    level);
    else
	return i1432_id_print_error(hw, ID, ERR1432_WHICH_TRIGGER_LEVEL);
}

SHORTSIZ16 EXPORT
e1432_get_trigger_level_limits(E1432ID hw, SHORTSIZ16 ID,
			       SHORTSIZ16 which,
			       FLOATSIZ32 *min, FLOATSIZ32 *max,
			       FLOATSIZ32 *def, FLOATSIZ32 *step)
{
    TRACE_PRINTF(0, ("e1432_get_trigger_level_limits(0x%p, %d, %d, "
		     "0x%p, 0x%p, 0x%p, 0x%p)\n",
		     hw, ID, which, min, max, def, step));
    if (which == E1432_TRIGGER_LEVEL_LOWER)
	return i1432_get_chan_limits(hw, ID,
				     E1432_LIM_SCA_TRIGGER_LEVEL_LOWER,
				     min, max, def, step);
    else if (which == E1432_TRIGGER_LEVEL_UPPER)
	return i1432_get_chan_limits(hw, ID,
				     E1432_LIM_SCA_TRIGGER_LEVEL_UPPER,
				     min, max, def, step);
    else
	return i1432_id_print_error(hw, ID, ERR1432_WHICH_TRIGGER_LEVEL);
}

SHORTSIZ16 EXPORT
e1432_set_trigger_level(E1432ID hw, SHORTSIZ16 ID, SHORTSIZ16 which,
			FLOATSIZ32 level)
{
    TRACE_PRINTF(0, ("e1432_set_trigger_level(0x%p, %d, %d, %g)\n",
		     hw, ID, which, level));

    if (which == E1432_TRIGGER_LEVEL_LOWER)
	return i1432_set_chan(hw, ID, E1432_TRIGGER_LEVEL_LOWER_CREG,
			      E1432_CCMD_SET_TRIGGER_LEVEL_LOWER,
			      *(LONGSIZ32 *) &level);
    else if (which == E1432_TRIGGER_LEVEL_UPPER)
	return i1432_set_chan(hw, ID, E1432_TRIGGER_LEVEL_UPPER_CREG,
			      E1432_CCMD_SET_TRIGGER_LEVEL_UPPER,
			      *(LONGSIZ32 *) &level);
    else
	return i1432_id_print_error(hw, ID, ERR1432_WHICH_TRIGGER_LEVEL);
}

/*
 *********************************************************************
 Return the scale factor needed to turn raw integer data into volts.
 *********************************************************************
 */
SHORTSIZ16 EXPORT
e1432_get_scale(E1432ID hw, SHORTSIZ16 ID, FLOATSIZ64 * scalePtr)
{
    SHORTSIZ16 error;
    FLOATSIZ32 ftmp;

    TRACE_PRINTF(0, ("e1432_get_scale(0x%p, %d, 0x%p)\n",
		     hw, ID, scalePtr));
    error = i1432_get_chan_float(hw, ID, E1432_SCALE_CREG, &ftmp);
    if (error < 0)
	return error;
    *scalePtr = ftmp;

    return 0;
}

/*
 *********************************************************************
 set the rpm arming channnel
 *********************************************************************
 */
SHORTSIZ16 EXPORT
e1432_set_arm_channel(E1432ID hw, SHORTSIZ16 ID, SHORTSIZ16 active)
{
    SHORTSIZ16 error;

    TRACE_PRINTF(0, ("e1432_set_arm_channel(0x%p, %d, %d)\n",
		     hw, ID, active));

    /* Check for valid id */
    error = i1432_checkID(hw, ID);
    if (error)
	return error;

    if (ID < 0)
	return i1432_print_error(ERR1432_EXPECT_CHANNEL);

    error = i1432_set_chan(hw, ID, -1, E1432_CMD_SET_ARM_CHANNEL, active);
    if (error)
	return error;

    return 0;
}

/*
 *********************************************************************
 get the rpm arming channnel
 *********************************************************************
 */
SHORTSIZ16 EXPORT
e1432_get_arm_channel(E1432ID hw, SHORTSIZ16 ID, SHORTSIZ16 *state)
{
    SHORTSIZ16 error, arm_chan;

    TRACE_PRINTF(0, ("e1432_get_arm_channel(0x%p, %d, 0x%p)\n",
		     hw, ID, state));

    error = i1432_get_mod_short(hw, ID, E1432_ARM_CHANNEL_REG,
				&arm_chan);
    if (error)
	return error;

    if (arm_chan == i1432_get_chan_index(hw, ID))
	*state = E1432_CHANNEL_ON;
    else
	*state = E1432_CHANNEL_OFF;

    return 0;
}

/* 
 *********************************************************************
 set the rpm arming channnel on a per input channel basis
 *********************************************************************
 */
SHORTSIZ16 EXPORT
e1432_set_arm_channel_per_input(E1432ID hw, SHORTSIZ16 ID, SHORTSIZ16 tachID)
{
    SHORTSIZ16 error;
    int     tachChan;
    E1432_MODULE_LIST_NODE *tachmn, *inputmn;

    TRACE_PRINTF(0, ("e1432_set_arm_channel(0x%p, %d, %d)\n",
                   hw, ID, tachID));

    if(tachID != -1)
    {
        /* Check for valid id */
        error = i1432_checkID(hw, tachID);
        if (error)
          return error;

        if (tachID < 0)
          return i1432_print_error(ERR1432_EXPECT_CHANNEL);
     
        error = i1432_get_module_from_chan(hw, ID, &inputmn);
        if (error)
	    return error;
	
        error = i1432_get_module_from_chan(hw, tachID, &tachmn);
        if (error)
	    return error;

	/* per input assignment of tachs not legal on multi module */
	if(tachmn != inputmn)
	    return i1432_id_print_error(hw, ID, ERR1432_ILLEGAL_ARM_CHAN_NUM);

	tachChan = i1432_get_chan_index(hw, tachID);
    }
    else
    {
      tachChan = -1;
    }


    error = i1432_set_chan(hw, ID, E1432_ARM_CHANNEL_PER_INPUT_CREG,
                      E1432_CCMD_SET_ARM_CHANNEL_PER_INPUT, tachChan);
    if (error)
      return error;

    return 0;
}

SHORTSIZ16 EXPORT
e1432_get_data_rpm(E1432ID hw, SHORTSIZ16 ID, FLOATSIZ32 *data_rpm)
{
    TRACE_PRINTF(0, ("e1432_get_data_rpm(0x%p, %d, 0x%p)\n",
		     hw, ID, data_rpm));

    /* If kludge data RPM flag is set, and the ID is one of the two
       tach channels on the master tach module, then use our saved
       data rpm rather than query the module.  Normally the saved
       value matches the value in the module.  However, if the module
       has no input channels active, then it may already have
       calculated the data RPM for the next trigger, and we want the
       data RPM for the current trigger. */
    if (i1432_kludge_data_rpm_flag)
    {
	if (ID == i1432_kludge_data_rpm_id1)
	{
	    *data_rpm = i1432_kludge_data_rpm1;
	    /* Don't reset i1432_kludge_data_rpm_flag here, do it in
	       the read data routines instead.  If we reset it here,
	       then multiple calls with the same ID would return
	       different values. */
	    return 0;
	}
	if (ID == i1432_kludge_data_rpm_id1 + 1)
	{
	    *data_rpm = i1432_kludge_data_rpm2;
	    return 0;
	}
    }

    return i1432_get_chan_float(hw, ID, E1432_DATA_RPM_CREG, data_rpm);
}

/*
 *********************************************************************
 This is not just a GET_MOD_SHORT macro, because we don't want to
 error if the modules are in different states.  Instead, we try to be
 smart about which state is furthest behind, and return that.
 *********************************************************************
 */
SHORTSIZ16 EXPORT
e1432_get_meas_state(E1432ID hw, SHORTSIZ16 ID, SHORTSIZ16 *ptr)
{
    E1432_MODULE_LIST_NODE *mn;
    E1432_GROUP_LIST_NODE *gn;
    SHORTSIZ16 error, min, max;
    LONGSIZ32 ltmp;
    int     mod;

    TRACE_PRINTF(0, ("e1432_get_meas_state(0x%p, %d, 0x%p)\n",
		     hw, ID, ptr));

    /* Check for valid id */
    error = i1432_checkID(hw, ID);
    if (error)
	return error;

    /* Check if channel or group */
    if (ID < 0)
    {
	/* Iterate through group */
	min = E1432_MEAS_STATE_MAX;
	max = 0;
	gn = i1432_get_group_node(hw, ID);
	for (mod = 0; mod < gn->modcount; mod++)
	{
	    /* Do one module */
	    mn = gn->modlist[mod];
	    error = e1432_get_meas_state(hw,
					 i1432_get_chan_from_module(mn),
					 ptr);
	    if (error)
		return error;

	    if (min > *ptr)
		min = *ptr;
	    if (max < *ptr)
		max = *ptr;
	}

	/* In general, we should return the minimum value of the
	   states of all the modules in the group.  But this runs into
	   two problems.

	   1. One module can get to pre-arm significantly ahead of the
	      others, and if this module does a state-change
	      interrupt, the resulting host call to
	      e1432_get_meas_state will not always say that the group
	      is ready for pre-arm.  This is inconvenient, so we go
	      ahead and return pre-arm for this case.  The main use
	      for this is for keeping a display up-to-date, so it
	      shouldn't cause problems.

	      We should consider doing the same for IDLE and TRIGGER,
	      which have the same sort of issue.  However, for these
	      states the timing mismatch between modules should
	      normally be very small.

	   2. The states wrap around from convert-wait2 back to idle,
	      except in continuous mode.  We must allow for the fact
	      that a module in idle state is ahead of a module in
	      convert-wait1 state, for example.  In addition, with
	      overlap-block mode and rapid triggering, the mismatch
	      between modules can be larger because we query the
	      modules at slightly different times.  To deal with this,
	      we allow for returning the max rather than the min if it
	      looks like one module has wrapped around ahead of the
	      other. */

	if (max == E1432_MEAS_STATE_PRE_ARM &&
	    min >= E1432_MEAS_STATE_SYNC)
	    /* Pre-arm case */
	    *ptr = max;
	else if (max - min > 4 && min >= E1432_MEAS_STATE_IDLE)
	    /* Assume min is ahead of max but wrapped around */
	    *ptr = max;
	else
	    /* Normal case */
	    *ptr = min;
    }
    else
    {
	/* get lone module */
	error = e1432_read32_register(hw, ID, E1432_MEAS_STATE_REG,
				      &ltmp);
	if (error)
	    return error;
	*ptr = (SHORTSIZ16) ltmp;
    }

    return 0;
}

/*
 *********************************************************************
 This is not just GET_MOD_LONG, because we don't want to error if the
 modules don't return the same value.  Instead, we want to return the
 minimum.
 *********************************************************************
 */
SHORTSIZ16 EXPORT
e1432_get_blocksize_current_max(E1432ID hw, SHORTSIZ16 ID,
				LONGSIZ32 *ptr)
{
    E1432_MODULE_LIST_NODE *mn;
    E1432_GROUP_LIST_NODE *gn;
    SHORTSIZ16 error;
    LONGSIZ32 min;
    int     mod;

    TRACE_PRINTF(0, ("e1432_get_blocksize_current_max(0x%p, %d, 0x%p)\n",
		     hw, ID, ptr));

    /* Check for valid id */
    error = i1432_checkID(hw, ID);
    if (error)
	return error;

    /* Check if channel or group */
    if (ID < 0)
    {
	/* Iterate through group, finding minimum */
	min = E1432_BLOCKSIZE_MAX;
	gn = i1432_get_group_node(hw, ID);
	for (mod = 0; mod < gn->modcount; mod++)
	{
	    /* Do one module */
	    mn = gn->modlist[mod];
	    error = e1432_get_blocksize_current_max
		(hw, i1432_get_chan_from_module(mn), ptr);
	    if (error)
		return error;

	    if (min > *ptr)
		min = *ptr;
	}
	*ptr = min;
    }
    else
	/* get lone module */
	return e1432_read32_register(hw, ID,
				     E1432_BLOCKSIZE_CURRENT_MAX_REG,
				     ptr);

    return 0;
}

/*
 *********************************************************************
 This is not just GET_MOD_LONG, because we don't want to error if the
 modules don't return the same value.  Instead, we want to return the
 minimum.
 *********************************************************************
 */
SHORTSIZ16 EXPORT
e1432_get_fifo_size_current_max(E1432ID hw, SHORTSIZ16 ID,
				LONGSIZ32 *ptr)
{
    E1432_MODULE_LIST_NODE *mn;
    E1432_GROUP_LIST_NODE *gn;
    SHORTSIZ16 error;
    LONGSIZ32 min;
    int     mod;

    TRACE_PRINTF(0, ("e1432_get_fifo_size_current_max(0x%p, %d, 0x%p)\n",
		     hw, ID, ptr));

    /* Check for valid id */
    error = i1432_checkID(hw, ID);
    if (error)
	return error;

    /* Check if channel or group */
    if (ID < 0)
    {
	/* Iterate through group, finding minimum */
	min = E1432_FIFO_SIZE_MAX;
	gn = i1432_get_group_node(hw, ID);
	for (mod = 0; mod < gn->modcount; mod++)
	{
	    /* Do one module */
	    mn = gn->modlist[mod];
	    error = e1432_get_fifo_size_current_max
		(hw, i1432_get_chan_from_module(mn), ptr);
	    if (error)
		return error;

	    if (min > *ptr)
		min = *ptr;
	}
	*ptr = min;
    }
    else
	/* get lone module */
	return e1432_read32_register(hw, ID,
				     E1432_FIFO_SIZE_CURRENT_MAX_REG,
				     ptr);

    return 0;
}

/*
 *********************************************************************
 update the dynamic source paramenters
 *********************************************************************
 */
SHORTSIZ16 EXPORT
e1432_update_srcparm(E1432ID hw, SHORTSIZ16 ID, LONGSIZ32 updatemode)
{
    SHORTSIZ16 error;

    TRACE_PRINTF(0, ("e1432_update_srcparm(0x%p, %d, %ld)\n",
		     hw, ID, updatemode));

    error = i1432_set_chan(hw, ID, -1, E1432_CCMD_UPDATE_SRCPARM, updatemode);
    if (error)
	return error;

    return 0;
}

/*
 *********************************************************************
 Get the fifo available value, from A bus SRAM address <reg>, in
 module <mn>, and put the value into <ptr>.
 *********************************************************************
 */
static SHORTSIZ16
get_fifo_avail2(E1432_MODULE_LIST_NODE *mn, LONGSIZ32 reg, LONGSIZ32 *ptr)
{
    SHORTSIZ16 error, error2;
    long    page, window, offset, start;

    page = E1432_A_SRAM_PAGE;
    if (mn->a24_256k)
    {
	window = E1432_WINDOW_BASE_256K;
	page <<= 2;
    }
    else
	window = E1432_WINDOW_BASE_1M;

    page += reg / window;
    offset = reg % window;

    start = 0;
#ifndef	HAVE_VTL
    if (!mn->a24_256k)
	/* When not using a24_256k and not using VTL, we map all of
	   the module's A24 space, so we want the address of the
	   movable window. */
	start = window;
#endif

    /* Set up page map register */
    error = i1432_direct_write_register(mn, E1432_PAGE_MAP_REG,
					(SHORTSIZ16) page);
    if (error)
	goto cleanup;

    error = i1432_direct_read32_register(mn, start + offset, ptr);
    if (error)
	goto cleanup;

 cleanup:
    /* Clean up page map register */
    error2 = i1432_direct_write_register(mn, E1432_PAGE_MAP_REG,
					 E1432_BASE_PAGE);
    if (error2)
	error = error2;

    return error;
}

/*
 *********************************************************************
 Get the number of samples available in the FIFO.  This is only
 approximate, but is still useful.  This function works only for
 channel IDs, and is called by e1432_get_current_value below.
 *********************************************************************
 */
static SHORTSIZ16
get_fifo_avail(E1432ID hw, SHORTSIZ16 ID, FLOATSIZ32 *ptr)
{
    E1432_MODULE_LIST_NODE *mn;
    SHORTSIZ16 error;
    LONGSIZ32 reg, tmp, tmp2;

    error = e1432_read32_register(hw, ID, E1432_FIFO_AVAIL_PTR_REG, &reg);
    if (error)
	return error;
    error = i1432_get_module_from_chan(hw, ID, &mn);
    if (error)
	return error;

    for ( ; ; )
    {
	/* If the I/O uses D16, there is the remote possibility that
	   the value changed in the middle of the two 16-bit reads.
	   As long as the most significant part of the value didn't
	   change, this is OK.  If the most significant part changed,
	   then we must try again. */
	error = get_fifo_avail2(mn, reg, &tmp);
	if (error)
	    return error;
	error = get_fifo_avail2(mn, reg, &tmp2);
	if (error)
	    return error;

	if ((tmp & 0xffff0000UL) == (tmp2 & 0xffff0000UL))
	{
	    *ptr = (FLOATSIZ32) tmp2;
	    return 0;
	}
    }
}

/*
 *********************************************************************
 Get current value of E1432_CURRENT_VAL_PEAK, E1432_CURRENT_VAL_RMS,
 or E1432_CURRENT_VAL_FIFO_AVAIL.  ptr points to a single value if
 single channel, or array if group.
 *********************************************************************
 */
SHORTSIZ16 EXPORT
e1432_get_current_value(E1432ID hw, SHORTSIZ16 ID, SHORTSIZ16 value_type,
			FLOATSIZ32 *ptr)
{
    SHORTSIZ16 error, error2, active;
    LONGSIZ32 chan;

    TRACE_PRINTF(0, ("e1432_get_current_value(0x%p, %d, %d, 0x%p)\n",
		     hw, ID, value_type, ptr));

    /* Check if channel or group */
    if (ID < 0)
    {
        E1432_GROUP_LIST_NODE *gn;
        E1432_CHAN_LIST_NODE *cn;
	/* Iterate thru group */
	gn = i1432_get_group_node(hw, ID);
	cn = gn->chanlist;
	while ( cn )
	{
	    error = e1432_get_current_value(hw, cn->chanID, value_type, ptr);
            if (error) return error;
	    ptr++;
	    cn = cn->next;
	}
    }
    else
    {
	if (value_type == E1432_CURRENT_VAL_FIFO_AVAIL)
	{
	    error = get_fifo_avail(hw, ID, ptr);
	    if (error)
		return error;
	}
	else if (i1432_get_chan_sca_id(hw, ID) == E1432_SCA_ID_VIBRATO &&
		 (value_type == E1432_CURRENT_VAL_PEAK ||
		  value_type == E1432_CURRENT_VAL_RMS))
	{
	    error = i1432_get_chan_float(hw, ID,
					 value_type ==
					 E1432_CURRENT_VAL_PEAK ?
					 E1432_CURRENT_PEAK_CREG :
					 E1432_CURRENT_RMS_CREG,
					 ptr);
	    if (error)
		return error;
	}
	else
	{
	    error = e1432_get_active(hw, ID, &active);
	    if (error)
		return error;
	    if (active == E1432_CHANNEL_ON)
	    {
		chan = i1432_get_chan_index(hw, ID);

		error = i1432_introff();
		if (error)
		    return error;

		error = i1432_write_cmd2(hw, ID, E1432_CMD_GET_CURRENT_VALUE,
					 (LONGSIZ32) value_type, chan);
		if (error == 0)
		    error = e1432_read32_register(hw, ID,
						  E1432_CURRENT_VALUE_REG,
						  (LONGSIZ32 *) ptr);

		error2 = i1432_intron();
		if (error2)
		    return error2;

		if (error)
		    return error;
	    }
	    else
	    {
		*ptr = 0;
	    }
	}
    }

    return 0;
}

/* These were formerly done with GET_CHAN_FLOAT.  But that returns
   only a single value when given a group ID, and if the values don't
   all match it errors.  So instead, just have them call
   e1432_get_current_value, which treats value as an array and fills
   in a separate value for each channel. */
SHORTSIZ16 EXPORT
e1432_get_current_peak(E1432ID hw, SHORTSIZ16 ID, FLOATSIZ32 *value)
{
    return e1432_get_current_value(hw, ID, E1432_CURRENT_VAL_PEAK, value);
}

SHORTSIZ16 EXPORT
e1432_get_current_rms(E1432ID hw, SHORTSIZ16 ID, FLOATSIZ32 *value)
{
    return e1432_get_current_value(hw, ID, E1432_CURRENT_VAL_RMS, value);
}

/*
 *********************************************************************
 Command to setup USER1 output.  For 3rd parties.
 *********************************************************************
 */
SHORTSIZ16 EXPORT
e1432_set_user_data(E1432ID hw, SHORTSIZ16 ID,
  LONGSIZ32 frame_length, SHORTSIZ16 word_length, SHORTSIZ16 sub_length,
  SHORTSIZ16 sub_pos)
{
    int mod;
    SHORTSIZ16 error = 0;
    E1432_MODULE_LIST_NODE *mn;
    E1432_GROUP_LIST_NODE *gn;

    TRACE_PRINTF(0, ("e1432_set_user_data(0x%p, %d, %ld, %d, %d, %d)\n",
		     hw, ID, frame_length, word_length,
		     sub_length, sub_pos));

    /* Check if channel or group */
    if (ID < 0)
    {
	/* Iterate through group */
	gn = i1432_get_group_node(hw, ID);
	for (mod = 0; mod < gn->modcount; mod++)
	{
	    /* Do one module */
	    mn = gn->modlist[mod];
	    error = e1432_set_user_data(hw, i1432_get_chan_from_module(mn),
              frame_length, word_length, sub_length, sub_pos);
	    if (error) return error;
	}
    }
    else
    {
        if ( frame_length < 1 )
        {
	    /* frame_length of 0 signifies that user data is to be turned off */
	    if ( frame_length != 0 )
	    {
	        return i1432_id_print_error(hw, ID, ERR1432_HARDWARE_INCAPABLE);
	    }
        }
	else
	{
            if ( word_length < 2 || word_length > 32 )
            {
	        return i1432_id_print_error(hw, ID, ERR1432_HARDWARE_INCAPABLE);
            }
            if ( sub_length < 2 || sub_length > 16 || sub_length > word_length )
            {
	        return i1432_id_print_error(hw, ID, ERR1432_HARDWARE_INCAPABLE);
            }
            if ( sub_pos < 0 || sub_pos >= 32 - sub_length )
            {
	        return i1432_id_print_error(hw, ID, ERR1432_HARDWARE_INCAPABLE);
            }
	}
        error = i1432_write_cmd4(hw, ID, E1432_CCMD_SET_USER_DATA, frame_length,
	  (LONGSIZ32)word_length, (LONGSIZ32)sub_length, (LONGSIZ32)sub_pos);
    }

    return error;
}


SHORTSIZ16 EXPORT
e1432_set_peak_mode(E1432ID hw, SHORTSIZ16 ID, SHORTSIZ16 peak_mode)
{
    TRACE_PRINTF(0, ("e1432_set_peak_mode(0x%p, %d, %d)\n", hw, ID, peak_mode));

    if ( peak_mode != E1432_PEAK_MODE_OFF 
      && peak_mode != E1432_PEAK_MODE_BLOCK
      && peak_mode != E1432_PEAK_MODE_FILT )
    {
	return i1432_print_error(ERR1432_ILLEGAL_PEAK_MODE);
    }

    return i1432_set_mod(hw, ID, E1432_PEAK_MODE_REG,
      E1432_CMD_SET_PEAK_MODE, (LONGSIZ32) peak_mode);
}


SHORTSIZ16 EXPORT
e1432_set_rms_mode(E1432ID hw, SHORTSIZ16 ID, SHORTSIZ16 rms_mode)
{
    TRACE_PRINTF(0, ("e1432_set_rms_mode(0x%p, %d, %d)\n", hw, ID, rms_mode));

    if ( rms_mode != E1432_RMS_MODE_OFF
      && rms_mode != E1432_RMS_MODE_BLOCK
      && rms_mode != E1432_RMS_MODE_BLOCK_ONLY
      && rms_mode != E1432_RMS_MODE_FILT )
    {
	return i1432_print_error(ERR1432_ILLEGAL_RMS_MODE);
    }

    return i1432_set_mod(hw, ID, E1432_RMS_MODE_REG,
      E1432_CMD_SET_RMS_MODE, (LONGSIZ32) rms_mode);
}
